// rt-esp32-timeradc01
// https://techtutorialsx.com/2017/10/07/esp32-arduino-timer-interrupts/

// https://docs.espressif.com/projects/esp-idf/en/latest/esp32/api-guides/freertos-smp.html

// https://microcontrollerslab.com/freertos-counting-semaphore-examples-arduino/

// JDN 2021

const int prescale = 80;  // 80 MHz  => 1 MHz

volatile int iCnt0 = 0, iCnt1 = 0, iCnt2 = 0, iCnt3 = 0;

hw_timer_t *timer0, *timer1, *timer2, *timer3;
SemaphoreHandle_t sem0, sem1, sem2, sem3;


// ISR
//--------------------------
// counting semaphore timed semaphore

void IRAM_ATTR onTimer0() {   // standard functinodeclaration + (!)   IRAM_ATTR which force compiler to place function in interal high speed RAM - for quick run of code

  xSemaphoreGiveFromISR( sem0, NULL);

}


void IRAM_ATTR onTimer1() {   // standard functinodeclaration + (!)   IRAM_ATTR which force compiler to place function in interal high speed RAM - for quick run of code

  xSemaphoreGiveFromISR( sem1, NULL);

}

// DEBUG ONLY
volatile int loop0 = 0, loop1 = 0;

void task1(void *pParms)
{
  int i = 0;
  while (1) {
    while (xSemaphoreTake(sem0, 1000) != pdTRUE) ; // wait 
    loop0++;
  }
}

void task2(void *pParms)
{

  while (1) {
    while (xSemaphoreTake(sem1, 1000) != pdTRUE) ;
    loop1++;

    vTaskDelay(1500 /portTICK_PERIOD_MS);  // so we wwill come behind

    Serial.print (millis());
    Serial.print(" sem1 value "); Serial.print(uxSemaphoreGetCount(sem1));
    Serial.print(" "); Serial.print(loop0); Serial.print(" "); Serial.println(loop1);
  }
}

void setup() {
  Serial.begin(115200);
  delay(2000);
  Serial.println("starting");

  // sem0 ....
  sem0 = xSemaphoreCreateCounting(100, 0);
  timer0 = timerBegin(0, 80, true); // 1usec pr tick

  timerAlarmWrite(timer0, 1000, true); // cyclic timer @ 1 Hz
  timerAttachInterrupt(timer0, onTimer0, true);


  // sem1 ...
  sem1 = xSemaphoreCreateCounting(100, 0);
  timer1 = timerBegin(1, 80, true); // 1 usec pr tick

  timerAlarmWrite(timer1, 1000000, true); // cyclic timer @ 1 Hz
  timerAttachInterrupt(timer1, onTimer1, true);

  // GOGO for timers
  timerAlarmEnable(timer0);
  timerAlarmEnable(timer1);


  xTaskCreate(task1, "t1", 2000, NULL,  2, NULL);
  xTaskCreate(task2, "t1", 2000, NULL,  2, NULL);
}

void loop() {
  vTaskDelay(100);
}
