#include <Wire.h>
#include <bmp085.h>

// NB NB find atm pressure at sealevel for today and adjust SEALEVEL below

#define SEALEVEL 102320.0

// ---

#define LOOPTIME 5
#define AVERSIZE 20

float ff[AVERSIZE];

void initAverageArray()
{
  static float pres, temp, alt;
  for (int i = 0; i < AVERSIZE; i++) {  // do AVERSIZE start measurements
    bmp085Measure(&temp, &pres, &alt);
    delay(LOOPTIME);
    ff[i] = alt;
  }
}

float calcAverage(float ff[])
{
  float mean = 0.0;

  for (int i = 0; i < AVERSIZE; i++)
    mean += ff[i];

  return (mean / AVERSIZE);
}

void setup()
{
  Serial.begin(115200);
  Wire.begin();
  delay(10);

  bmp085Init(0x77,SEALEVEL); // ress at sealevel today 0x76 or 0x77 
  delay(10);

  initAverageArray();
}


void loop()
{
  // placed here with static to guard by use of scoperules
  static int index = 0;

  static float pres, temp, alt;
  static float averageAltitude;
  

  bmp085Measure(&temp, &pres, &alt);
  // overwrite oldest value
  ff[index] = alt;
  index++;
  if (AVERSIZE <= index)  // wrap around
    index = 0;


  averageAltitude = calcAverage(ff);

  Serial.print(alt); Serial.print(" ");
  Serial.println(averageAltitude); 
  delay(LOOPTIME);
}

 /* ende */
