// JDN oct 2024

#include <mpu606x.h>

unsigned char mpu606xAddr = 0x68;  // or 0x69

unsigned char accRange;
unsigned char gyroRange;
 unsigned int data[6];

  // 0x18 +- 16G
  // 0x10 +-8 G
  // 0x08 +-4
  // 0x00 +-2
void mpu606xConfigAcc(unsigned char confReg)
{

  // Select accelerometer configuration register
  // Full scale range = +/-16g
  // 7 6 5 4 3 2 1 0
  //       x x
  // 1 1 1 0 0 1 1 1   = 0xe7
  // 0x18 +- 16G
  // 0x10 +-8 G
  // 0x08 +-4
  // 0x00 +-2
  // Stop I2C transmission
  // valid we set it to +- 16G
  accRange= confReg;
  if ( confReg & 0xe7 != 0) {
	  accRange = 0x18;  
  }
	  
  Wire.beginTransmission(mpu606xAddr);
  Wire.write(0x1C);
  Wire.write(accRange);
  Wire.endTransmission();
}


  // Full scale range = 2000 dps
  // 0x18 +- 2000 degr/sec
  // 0x10 +- 1000 gr/sec
  // 0x08 +- 500 gr/Sec
  // 0x00 +- 250 gr/sec
void mpu606xConfigGyro(unsigned char confReg)
{

  // Full scale range = 2000 dps
  // 0x18 +- 2000 degr/sec
  // 0x10 +- 1000 gr/sec
  // 0x08 +- 500 gr/Sec
  // 0x00 +- 250 gr/sec
  
  gyroRange= confReg;
  if ( confReg & 0xe7 != 0) {
	  gyroRange = 0x18;  // max
  }
	  
  Wire.beginTransmission(mpu606xAddr);
  Wire.write(0x1B);
  Wire.write(gyroRange);
  Wire.endTransmission();
}

void mpu606xInit(unsigned char a)
{
	mpu606xAddr = a;
  Wire.beginTransmission(mpu606xAddr);
  // Select power management register
  Wire.write(0x6B);
  // PLL with xGyro reference
  Wire.write(0x01);
  // Stop I2C transmission
  Wire.endTransmission();
}
 
void mpu606XgetAcc(int *accX, int *accY, int *accZ)
{
  Wire.beginTransmission(mpu606xAddr);
  // Select data register
  Wire.write(0x3B);
  // Stop I2C transmission
  Wire.endTransmission();
  
  // Request 6 bytes of data
  Wire.requestFrom(mpu606xAddr, 6);
  
  // Read 6 byte of data 
  if(Wire.available() == 6)
  {
    data[0] = Wire.read();
    data[1] = Wire.read();
    data[2] = Wire.read();
    data[3] = Wire.read();
    data[4] = Wire.read();
    data[5] = Wire.read(); 
  }
  
  // Convert the data
  *accX = data[0] * 256 + data[1];
  *accY = data[2] * 256 + data[3];
  *accZ = data[4] * 256 + data[5];
}

void mpu606XgetGyro(int *gyroX, int *gyroY, int *gyroZ)
{
	
  Wire.beginTransmission(mpu606xAddr);
  // Select data register
  Wire.write(0x43);
  // Stop I2C transmission
  Wire.endTransmission();
  
  // Request 6 bytes of data
  Wire.requestFrom(mpu606xAddr, 6);
  
  // Read 6 byte of data 
  if(Wire.available() == 6)
  {
    data[0] = Wire.read();
    data[1] = Wire.read();
    data[2] = Wire.read();
    data[3] = Wire.read();
    data[4] = Wire.read();
    data[5] = Wire.read(); 
  }
  
  // Convert the data
  *gyroX = (int)(data[0] * 256 + data[1]);
  *gyroY = (int)(data[2] * 256 + data[3]);
  *gyroZ = (int)(data[4] * 256 + data[5]);
 
}
