// JDN Oct 2024
#ifndef MPU606X
#define MPU606X

#include <Wire.h>

extern unsigned char mpu606xAddr;

extern unsigned char accRange;
extern unsigned char gyroRange;
 
  // 0x18 +- 16G
  // 0x10 +-8 G
  // 0x08 +-4
  // 0x00 +-2
void mpu606xConfigAcc(unsigned char confReg);


  // Full scale range = 2000 dps
  // 0x18 +- 2000 degr/sec
  // 0x10 +- 1000 gr/sec
  // 0x08 +- 500 gr/Sec
  // 0x00 +- 250 gr/sec
void mpu606xConfigGyro(unsigned char confReg);


void mpu606xInit(unsigned char cfg);

void mpu606XgetAcc(int *accX, int *accY, int *accZ);

void mpu606XgetGyro(int *gyroX, int *gyroY, int *gyroZ);

#endif
