% Matlab code to generate bode plot
% This code will work without the 
% builtin bode function.
% This example is for the following transfer function
% s/(s+1e5)

clear all;


wstart=log10(1e3);
wfinish=log10(1e7);
omega=logspace(wstart,wfinish,100);

s=i*omega;

num=s;
den=s+1e5;
xfer_function=num./den;

xfer_function_magdB=20*log10(abs(xfer_function));
xfer_function_phase=(360/(2*pi))*phase(xfer_function);

figure; 
subplot(211); semilogx(omega,xfer_function_magdB);
ylabel('Magnitude (dB)')
grid on;
subplot(212); semilogx(omega,xfer_function_phase);
grid on;
ylabel('Phase (deg)')
xlabel('Frequency (rad/sec)');




